<?php
/*
	Stempora Web Framework
	Copyright (c) 2002-2018 Stempora. 
	All rights reserved.
		web:  www.stempora.com
		mail: support@stempora.com		
*/

// dependencies

/**
* description
*
* @library	
* @author	
* @since	
*/
class CPortfolio extends CPlugin{
	
	var $tplvars; 

	var $media = array(
		"hide"	=> array(
			"list"	=> array(
				"item_show",
			),
			"edit"	=> array(
				"item_show",
			)
		),

		"tn"	=> array(
			"width"		=> "1170",
			"height"	=> ""
		),

		"tn2"	=> array(
			"width"		=> "1170",
			"height"	=> "661"
		),
		

		"path"	=> "./portfolio/"

	);

	function __construct() {
		$this->name = "portfolio";
	}

	function DoEvents(){
		global $base, $_CONF, $_TSM , $_VARS , $_USER , $_BASE , $_SESS;
		

		if ($_GET["mod"] == $this->name) {

			//read the module
			$this->tpl_module = $this->module->plugins["modules"]->getModuleInfo($_GET["module_id"]);
			$this->plugins["modules"]->ValidateModule($this->tpl_module);

			parent::DoEvents();

			$sub = $_GET["sub"];
			$action = $_GET["action"];

			switch ($sub) {


				case "landing":
					$sub = "items";
				case "items":
				case "cats":
					$data = new CSQLAdmin($sub, $this->__parent_templates,$this->db,$this->tables,$extra);
					$data->setAclMod($this->tpl_module);
					$this->PrepareFields($data->forms["forms"]);

					$data->functions = array( 
							"onstore" => array(&$this , "StoreRecord"),
							"ondelete" => array(&$this , "DeleteRecord"),
					);					

					return $data->DoEvents();
				break;


				case "texts":
					return $this->__adminTexts();
				break;

			}
		}
	}


	function DeleteRecord($record) {

		switch ($_GET["sub"]) {
			case "topics.images":

				$last = $this->db->QFetchArray("SELECT * FROM {$this->tables['plugin:portfolio_images']} WHERE item_parent={$record[item_parent]} AND item_id!={$record[item_id]} AND item_type=1 AND item_image=1 ORDER BY item_order ASC LIMIT 1");

				$this->db->QueryUpdate(
					$this->tables["plugin:portfolio_items"],
					array(
						"item_tn"	=> $last["item_id"]
					),
					"item_id={$record[item_parent]}"
				);

			break;
		}
		

	}

	/**
	* description
	*
	* @param
	*
	* @return
	*
	* @access
	*/
	function StoreRecord($record) {

		switch ($_GET["sub"]) {
			case "items.images":

				if ($record["item_id"]) {

					$last = $this->db->QFetchArray("SELECT * FROM {$this->tables['plugin:portfolio_images']} WHERE item_parent={$record[item_parent]} AND item_type=1 AND item_image=1 ORDER BY item_order ASC LIMIT 1");

					if (is_Array($last)) {
						$this->db->QueryUpdate(
							$this->tables["plugin:portfolio_items"],
							array(
								"item_tn"	=> $last["item_id"]
							),
							"item_id={$record[item_parent]}"
						);
					}
					
				}
			break;

			case "_items":
				$this->db->QueryUpdate(
					$this->tables["plugin:portfolio_cats"],
					array(
						"cat_items"	=> $this->db->RowCount($this->tables['plugin:portfolio_items'] , " WHERE item_cat={$record[item_cat]} ")
					),
					"cat_id={$record[item_cat]}"
				);

			break;
		}
		
	}

	
	/**
	* description
	*
	* @param
	*
	* @return
	*
	* @access
	*/
	function onDelete($module_data) {

		$tables  = array(
			"plugin:portfolio_cats" , 
			"plugin:portfolio_cats_lang",
			"plugin:portfolio_items",
			"plugin:portfolio_items_lang",
			"plugin:portfolio_images",
			"plugin:portfolio_images_lang",
		);

		foreach ($tables as $key => $val) {
			$this->db->Query(
				"DELETE FROM " . $this->tables[$val] . " WHERE module_id={$module_data[mod_id]}"
			);
		}

		parent::onDelete($module_data);	
	}
	
	/**
	* description
	*
	* @param
	*
	* @return
	*
	* @access
	*/
	function onCreate($module_data) {

		$this->CreatePageTitleBlock(array(
			"module_id"	=> $module_data["mod_id"],
			"title"		=> $module_data["mod_name"],
			"subtitle"	=> "You can edit this section in the Module Head tab",
			"show"		=> 1,
		));



		$this->plugins["modules"]->CreateLangRecord(
			$this->tables["plugin:portfolio_cats"],
			$this->tables["plugin:portfolio_cats_lang"],
			"cat_id",
			"cat_order",
			array(
				"module_id"		=> $module_data["mod_id"],
				"cat_title"		=> "Default Category",
				"cat_status"	=> "1",
			)
		);

	}

	
}

?>